package gov.cms.grouper.snf.app;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.factory.ProcessableFactory;
import gov.cms.grouper.snf.SnfComponentName;
import gov.cms.grouper.snf.SnfComponentVersion;
import gov.cms.grouper.snf.SnfOption;
import gov.cms.grouper.snf.SnfRuntimeOption;
import gov.cms.grouper.snf.transfer.ISnfClaim;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FactoryInitializationTest {

  @Test
  public void testInitializeUsingProcessableFactory() throws Exception {
    Processable<ISnfClaim, SnfOption, SnfRuntimeOption> snfComponent = ProcessableFactory
          .createComponent(SnfComponentName.Snf, SnfComponentVersion.v100, null);
      Assertions.assertNotNull(snfComponent, "Cannot create component with version " + SnfComponentVersion.v100.name());
  }

  @Test
  public void testInitializeUsingProcessableFactoryNull() throws Exception {
    assertNullComponentCreation(SnfComponentVersion.v104);
    assertNullComponentCreation(SnfComponentVersion.v105);
    assertNullComponentCreation(SnfComponentVersion.v109);
  }

  @Test
  public void testPackageValueNotEqual() {
    Assertions.assertNotEquals("v100", SnfComponentVersion.v100.getPackageValue());
  }

  private void assertNullComponentCreation(SnfComponentVersion version) throws Exception{
    Processable<ISnfClaim, SnfOption, SnfRuntimeOption> snfComponent = null;
    try {
       snfComponent = ProcessableFactory
          .createComponent(SnfComponentName.Snf, version, null);
    } catch (FoundationException ignored) { }
    Assertions.assertNull(snfComponent, "Cannot create component with version " + version.name());
  }
}
